#include<bits/stdc++.h>

using namespace std;

struct Point {
    long long x, y;
    
    bool operator<(const Point& other) const {
        return x < other.x || (x == other.x && y < other.y);
    }
};

long long crossProduct(const Point& O, const Point& A, const Point& B) {
    return (A.x - O.x) * (B.y - O.y) - (A.y - O.y) * (B.x - O.x);
}

vector<Point> convexHull(vector<Point>& points) {
    sort(points.begin(), points.end());
    sort(points.begin(), points.end());

    vector<Point> hull;

    for (const auto& p : points) {
        while (hull.size() >= 2 && crossProduct(hull[hull.size() - 2], hull.back(), p) <= 0)
            hull.pop_back();
        hull.push_back(p);
    }

    size_t t = hull.size() + 1;
    for (auto it = points.rbegin(); it != points.rend(); ++it) {
        while (hull.size() >= t && crossProduct(hull[hull.size() - 2], hull.back(), *it) <= 0)
            hull.pop_back();
        hull.push_back(*it);
    }

    hull.pop_back(); 
    return hull;
}


int main() {
	int n;
	cin >> n;
	
	vector<Point> polygon;
	long long x,y;
	
	for(int i=0;i<n;i++){
		cin >> x >> y;
		polygon.push_back({x,y});
	}
	
	if(n==4){
		long long maxArea = LLONG_MAX;
		
		vector<Point> hull = convexHull(polygon);

	    for (int i = 0; i < 4; ++i) {
	        vector<Point> subset;
	        for (int j = 0; j < 4; ++j) {
	            if (j != i) { 
	                subset.push_back(hull[j]);
	            }
	        }
	        
	        long long currentArea = 0;
	    
		    for (int i = 0; i < 3; ++i) {
		        int j = (i + 1) % n; 
		        currentArea += subset[i].x * subset[j].y - subset[i].y * subset[j].x;
		    }
		 	
		    maxArea = min(maxArea, abs(currentArea) / 2);
	    }
	    
	    cout << maxArea;
	}
	else{
		long long area = 0;

	    for (int i = 1; i < n; ++i) {
	    	
	        int j = (i + 1) % n;
	        if(j == 0) j++;
	        
	        area += polygon[i].x * polygon[j].y - polygon[i].y * polygon[j].x;
	    }
	    
	    cout << abs(area) / 2;

	}
	
	return 0;
}